# -*- coding: utf-8 -*-
"""
Daniel Calderon S.

file: AuxiliaryFunctions.py
---------------------------
V1.3 - 31/05/2012
    objList_objloader:
    carga archivos obj utilizando objloader extraído de: http://www.pygame.org/wiki/OBJFileLoader
    
    objList:
    Función de carga de archivos OBJ. Permite escoger si cargar sólo forma, materiales y/o texturas.
    Permitiendo cargar diguras de las que no se dispone de las texturas o el archivo de mtl.

V1.2 - 15/05/2012
    Dibujos directos de triangulos y cuadriláteros.
    Soporte para dibujos en base a Clase Vector3D V1.0
    Corregidos algunos errores.
    
V1.1 - 13/05/2012
    Funciones varias para simplificar el proceso de dibujo
"""

from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *

#####################################################################

def printVersions():
    print "GPU                      = ",glGetString(GL_VENDOR)
    print "Renderer                 = ",glGetString(GL_RENDERER)
    print "OpenGL                   = ",glGetString(GL_VERSION)
    print "Shading Language Version = ",glGetString(GL_SHADING_LANGUAGE_VERSION)
    #print "Extensions = "
    #print glGetString(GL_EXTENSIONS)

#####################################################################

def draw2Vertexfv(a,b):
    n = len(a)
    if n == 2:
        glVertex2fv(a)
        glVertex2fv(b)
    elif n == 3:
        glVertex3fv(a)
        glVertex3fv(b)
    elif n == 4:
        glVertex4fv(a)
        glVertex4fv(b)
        
def draw2Vertexfvn(a,b,n):
    glNormal3fv(n)    
    draw2Vertexfv(a,b)

def draw2Vertexfvn2(a,b,na,nb):
    n = len(a)
    if n == 2:
        glNormal3fv(na)
        glVertex2fv(a)
        glNormal3fv(nb) 
        glVertex2fv(b)
    elif n == 3:
        glNormal3fv(na)
        glVertex3fv(a)
        glNormal3fv(nb) 
        glVertex3fv(b)
    elif n == 4:
        glNormal3fv(na)
        glVertex4fv(a)
        glNormal3fv(nb) 
        glVertex4fv(b)
        
#####################################################################
    
def draw3Vertexfv(a,b,c):
    n = len(a)
    if n == 2:
        glVertex2fv(a)
        glVertex2fv(b)
        glVertex2fv(c)
    elif n == 3:
        glVertex3fv(a)
        glVertex3fv(b)
        glVertex3fv(c)
    elif n == 4:
        glVertex4fv(a)
        glVertex4fv(b)
        glVertex4fv(c)

def draw3Vertexfvn(a,b,c,n):
    glNormal3fv(n)    
    draw3Vertexfv(a,b,c)

def draw3Vertexfvn3(a,b,c,na,nb,nc):
    n = len(a)
    if n == 2:
        glNormal3fv(na)
        glVertex2fv(a)
        glNormal3fv(nb) 
        glVertex2fv(b)
        glNormal3fv(nc) 
        glVertex2fv(c)
    elif n == 3:
        glNormal3fv(na)
        glVertex3fv(a)
        glNormal3fv(nb) 
        glVertex3fv(b)
        glNormal3fv(nc) 
        glVertex3fv(c)
    elif n == 4:
        glNormal3fv(na)
        glVertex4fv(a)
        glNormal3fv(nb) 
        glVertex4fv(b)
        glNormal3fv(nc) 
        glVertex4fv(c)

#####################################################################

def drawTriangle(a,b,c):
    glBegin(GL_TRIANGLES)
    draw3Vertexfv(a,b,c)
    glEnd()

def drawTrianglen(a,b,c,n):
    glBegin(GL_TRIANGLES)
    draw3Vertexfvn(a,b,c,n)
    glEnd()

def drawTrianglen3(a,b,c,na,nb,nc):
    glBegin(GL_TRIANGLES)
    draw3Vertexfvn3(a,b,c,na,nb,nc)
    glEnd()

#####################################################################

def tdraw3Vertexfv(a,b,c,ta,tb,tc):
    n = len(a)
    if n == 2:
        glTexCoord2fv(ta)
        glVertex2fv(a)
        glTexCoord2fv(tb)
        glVertex2fv(b)
        glTexCoord2fv(tc)
        glVertex2fv(c)
    elif n == 3:
        glTexCoord2fv(ta)
        glVertex3fv(a)
        glTexCoord2fv(tb)
        glVertex3fv(b)
        glTexCoord2fv(tc)
        glVertex3fv(c)
    elif n == 4:
        glTexCoord2fv(ta)
        glVertex4fv(a)
        glTexCoord2fv(tb)
        glVertex4fv(b)
        glTexCoord2fv(tc)
        glVertex4fv(c)

def tdraw3Vertexfvn(a,b,c,n,ta,tb,tc):
    glNormal3fv(n)
    tdraw3Vertexfv(a,b,c,ta,tb,tc)

def tdraw3Vertexfvn3(a,b,c,na,nb,nc,ta,tb,tc):
    n = len(a)
    if n == 2:
        glTexCoord2fv(ta)
        glNormal3fv(na)
        glVertex2fv(a)
        
        glTexCoord2fv(tb)
        glNormal3fv(nb) 
        glVertex2fv(b)
        
        glTexCoord2fv(tc)
        glNormal3fv(nc) 
        glVertex2fv(c)
    elif n == 3:
        glTexCoord2fv(ta)
        glNormal3fv(na)
        glVertex3fv(a)
        
        glTexCoord2fv(tb)
        glNormal3fv(nb) 
        glVertex3fv(b)
        
        glTexCoord2fv(tc)
        glNormal3fv(nc) 
        glVertex3fv(c)
    elif n == 4:
        glTexCoord2fv(ta)
        glNormal3fv(na)
        glVertex4fv(a)
        
        glTexCoord2fv(tb)
        glNormal3fv(nb) 
        glVertex4fv(b)
        
        glTexCoord2fv(tc)
        glNormal3fv(nc) 
        glVertex4fv(c)

#####################################################################

def tdrawTriangle(a,b,c):
    glBegin(GL_TRIANGLES)
    tdraw3Vertexfv(a,b,c)
    glEnd()

def tdrawTrianglen(a,b,c,n):
    glBegin(GL_TRIANGLES)
    tdraw3Vertexfvn(a,b,c,n)
    glEnd()

def tdrawTrianglen3(a,b,c,na,nb,nc):
    glBegin(GL_TRIANGLES)
    tdraw3Vertexfvn3(a,b,c,na,nb,nc)
    glEnd()

#####################################################################

def draw4Vertexfv(a,b,c,d):
    n = len(a)
    if n == 2:
        glVertex2fv(a)
        glVertex2fv(b)
        glVertex2fv(c)
        glVertex2fv(d)
    elif n == 3:
        glVertex3fv(a)
        glVertex3fv(b)
        glVertex3fv(c)
        glVertex3fv(d)
    elif n == 4:
        glVertex4fv(a)
        glVertex4fv(b)
        glVertex4fv(c)
        glVertex4fv(d)

def draw4Vertexfvn(a,b,c,d,n):
    glNormal3fv(n)    
    draw4Vertexfv(a,b,c,d)

def draw4Vertexfvn4(a,b,c,d,na,nb,nc,nd):
    n = len(a)
    if n == 2:
        glNormal3fv(na)
        glVertex2fv(a)
        glNormal3fv(nb) 
        glVertex2fv(b)
        glNormal3fv(nc) 
        glVertex2fv(c)
        glNormal3fv(nd) 
        glVertex2fv(d)
    elif n == 3:
        glNormal3fv(na)
        glVertex3fv(a)
        glNormal3fv(nb) 
        glVertex3fv(b)
        glNormal3fv(nc) 
        glVertex3fv(c)
        glNormal3fv(nd) 
        glVertex3fv(d)
    elif n == 4:
        glNormal3fv(na)
        glVertex4fv(a)
        glNormal3fv(nb) 
        glVertex4fv(b)
        glNormal3fv(nc) 
        glVertex4fv(c)
        glNormal3fv(nd) 
        glVertex4fv(d)

#####################################################################

def drawQuad(a,b,c,d):
    glBegin(GL_QUADS)
    draw4Vertexfv(a,b,c,d)
    glEnd()

def drawQuadn(a,b,c,d,n):
    glBegin(GL_QUADS)
    draw4Vertexfvn(a,b,c,d,n)
    glEnd()

def drawQuadn4(a,b,c,d,na,nb,nc,nd):
    glBegin(GL_QUADS)
    draw4Vertexfvn4(a,b,c,d,na,nb,nc,nd)
    glEnd()
    
#####################################################################

def tdraw4Vertexfv(a,b,c,d,ta,tb,tc,td):
    n = len(a)
    if n == 2:
        glTexCoord2fv(ta)
        glVertex2fv(a)
        glTexCoord2fv(tb)
        glVertex2fv(b)
        glTexCoord2fv(tc)
        glVertex2fv(c)
        glTexCoord2fv(td)
        glVertex2fv(d)
    elif n == 3:
        glTexCoord2fv(ta)
        glVertex3fv(a)
        glTexCoord2fv(tb)
        glVertex3fv(b)
        glTexCoord2fv(tc)
        glVertex3fv(c)
        glTexCoord2fv(td)
        glVertex3fv(d)
    elif n == 4:
        glTexCoord2fv(ta)
        glVertex4fv(a)
        glTexCoord2fv(tb)
        glVertex4fv(b)
        glTexCoord2fv(tc)
        glVertex4fv(c)
        glTexCoord2fv(td)
        glVertex4fv(d)

def tdraw4Vertexfvn(a,b,c,d,n,ta,tb,tc,td):
    glNormal3fv(n)
    tdraw4Vertexfv(a,b,c,d,ta,tb,tc,td)

def tdraw4Vertexfvn4(a,b,c,d,na,nb,nc,nd,ta,tb,tc,td):
    n = len(a)
    if n == 2:
        glTexCoord2fv(ta)
        glNormal3fv(na)
        glVertex2fv(a)
        
        glTexCoord2fv(tb)
        glNormal3fv(nb) 
        glVertex2fv(b)
        
        glTexCoord2fv(tc)
        glNormal3fv(nc) 
        glVertex2fv(c)
        
        glTexCoord2fv(td)
        glNormal3fv(nd) 
        glVertex2fv(d)
    elif n == 3:
        glTexCoord2fv(ta)
        glNormal3fv(na)
        glVertex3fv(a)
        
        glTexCoord2fv(tb)
        glNormal3fv(nb) 
        glVertex3fv(b)
        
        glTexCoord2fv(tc)
        glNormal3fv(nc) 
        glVertex3fv(c)
        
        glTexCoord2fv(td)
        glNormal3fv(nd) 
        glVertex3fv(d)
    elif n == 4:
        glTexCoord2fv(ta)
        glNormal3fv(na)
        glVertex4fv(a)
        
        glTexCoord2fv(tb)
        glNormal3fv(nb) 
        glVertex4fv(b)
        
        glTexCoord2fv(tc)
        glNormal3fv(nc) 
        glVertex4fv(c)
        
        glTexCoord2fv(td)
        glNormal3fv(nd) 
        glVertex4fv(d)
        
#####################################################################

def tdrawQuad(a,b,c,d,ta,tb,tc,td):
    glBegin(GL_QUADS)
    draw4Vertexfv(a,b,c,d,ta,tb,tc,td)
    glEnd()

def tdrawQuadn(a,b,c,d,n,ta,tb,tc,td):
    glBegin(GL_QUADS)
    draw4Vertexfvn(a,b,c,d,n,ta,tb,tc,td)
    glEnd()

def tdrawQuadn4(a,b,c,d,na,nb,nc,nd,ta,tb,tc,td):
    glBegin(GL_QUADS)
    draw4Vertexfvn4(a,b,c,d,na,nb,nc,nd,ta,tb,tc,td)
    glEnd()
        
#####################################################################
# Encapsulados para Vector3D
#####################################################################
  
def vdraw3Vertexfv(a,b,c):
    draw3Vertexfv(a.cartesianas(),b.cartesianas(),c.cartesianas())

def vdraw3Vertexfvn(a,b,c,n):
    draw3Vertexfv(a.cartesianas(),b.cartesianas(),c.cartesianas(),n.cartesianas())

def vdraw3Vertexfvn3(a,b,c,na,nb,nc):
    draw3Vertexfvn3(a.cartesianas(),b.cartesianas(),c.cartesianas(),na.cartesianas(),nb.cartesianas(),nc.cartesianas())

#####################################################################

def vtdraw3Vertexfv(a,b,c,ta,tb,tc):
    tdraw3Vertexfv(a.cartesianas(),b.cartesianas(),c.cartesianas(),ta,tb,tc)

def vtdraw3Vertexfvn(a,b,c,n,ta,tb,tc):
    tdraw3Vertexfvn(a.cartesianas(),b.cartesianas(),c.cartesianas(),n.cartesianas(),ta,tb,tc)

def vtdraw3Vertexfvn3(a,b,c,na,nb,nc,ta,tb,tc):
    tdraw3Vertexfvn3(a.cartesianas(),b.cartesianas(),c.cartesianas(),na.cartesianas(),nb.cartesianas(),nc.cartesianas(),ta,tb,tc)

#####################################################################

def vdraw4Vertexfv(a,b,c,d):
    draw4Vertexfv(a.cartesianas(),b.cartesianas(),c.cartesianas(),d.cartesianas())

def vdraw4Vertexfvn(a,b,c,d,n):
    draw4Vertexfvn(a.cartesianas(),b.cartesianas(),c.cartesianas(),d.cartesianas(),n.cartesianas())

def vdraw4Vertexfvn4(a,b,c,d,na,nb,nc,nd):
    draw4Vertexfvn4(a.cartesianas(),b.cartesianas(),c.cartesianas(),d.cartesianas(),na.cartesianas(),nb.cartesianas(),nc.cartesianas(),nd.cartesianas())

#####################################################################

def vtdraw4Vertexfv(a,b,c,d,ta,tb,tc,td):
    tdraw4Vertexfv(a.cartesianas(),b.cartesianas(),c.cartesianas(),d.cartesianas(),ta,tb,tc,td)

def vtdraw4Vertexfvn(a,b,c,d,n,ta,tb,tc,td):
    tdraw4Vertexfv(a.cartesianas(),b.cartesianas(),c.cartesianas(),d.cartesianas(),n.cartesianas(),ta,tb,tc,td)

def vtdraw4Vertexfvn4(a,b,c,d,na,nb,nc,nd,ta,tb,tc,td):
    tdraw4Vertexfvn4(a.cartesianas(),b.cartesianas(),c.cartesianas(),d.cartesianas(),na.cartesianas(),nb.cartesianas(),nc.cartesianas(),nd.cartesianas(),ta,tb,tc,td)

#####################################################################
#####################################################################

def vdrawTriangle(a,b,c):
    drawTriangle(a.cartesianas(),b.cartesianas(),c.cartesianas())

def vdrawTrianglen(a,b,c,n):
    drawTrianglen(a.cartesianas(),b.cartesianas(),c.cartesianas(),n.cartesianas())

def vdrawTrianglen3(a,b,c,na,nb,nc):
    drawTrianglen3(a.cartesianas(),b.cartesianas(),c.cartesianas(),na.cartesianas(),nb.cartesianas(),nc.cartesianas())

#####################################################################

def vtdrawTriangle(a,b,c,ta,tb,tc):
    tdrawTriangle(a.cartesianas(),b.cartesianas(),c.cartesianas(),ta,tb,tc)

def vtdrawTrianglen(a,b,c,n,ta,tb,tc):
    tdrawTrianglen(a.cartesianas(),b.cartesianas(),c.cartesianas(),n.cartesianas(),ta,tb,tc)

def vtdrawTrianglen3(a,b,c,na,nb,nc,ta,tb,tc):
    tdrawTrianglen3(a.cartesianas(),b.cartesianas(),c.cartesianas(),na.cartesianas(),nb.cartesianas(),nc.cartesianas(),ta,tb,tc)

#####################################################################

def vdrawQuad(a,b,c,d):
    drawQuad(a.cartesianas(),b.cartesianas(),c.cartesianas(),d.cartesianas())

def vdrawQuadn(a,b,c,d,n):
    drawQuadn(a.cartesianas(),b.cartesianas(),c.cartesianas(),d.cartesianas(),n.cartesianas())

def vdrawQuadn4(a,b,c,d,na,nb,nc,nd):
    drawQuadn4(a.cartesianas(),b.cartesianas(),c.cartesianas(),d.cartesianas(),na.cartesianas(),nb.cartesianas(),nc.cartesianas(),nd.cartesianas())

#####################################################################

def vtdrawQuad(a,b,c,d,ta,tb,tc,td):
    tdrawQuad(a.cartesianas(),b.cartesianas(),c.cartesianas(),d.cartesianas(),ta,tb,tc,td)

def vtdrawQuadn(a,b,c,d,n,ta,tb,tc,td):
    tdrawQuadn(a.cartesianas(),b.cartesianas(),c.cartesianas(),d.cartesianas(),n.cartesianas(),ta,tb,tc,td)

def vtdrawQuadn4(a,b,c,d,na,nb,nc,nd,ta,tb,tc,td):
    tdrawQuadn4(a.cartesianas(),b.cartesianas(),c.cartesianas(),d.cartesianas(),na.cartesianas(),nb.cartesianas(),nc.cartesianas(),nd.cartesianas(),ta,tb,tc,td)

#####################################################################

def axesList(h):
    # h : lenght of the axes
    # draw axis X in red
    # draw axis Y in green
    # draw axis Z in blue
    
    x = [h,0,0,1]
    y = [0,h,0,1]
    z = [0,0,h,1]
    o = [0,0,0,1]
    
    lista = glGenLists(1)
    glNewList(lista, GL_COMPILE)
    
    glBegin(GL_LINES)
    
    glColor4fv([1,0,0,1])
    draw2Vertexfv(o,x)
    
    glColor4fv([0,1,0,1])
    draw2Vertexfv(o,y)
    
    glColor4fv([0,0,1,1])
    draw2Vertexfv(o,z)
    
    glEnd()
    
    glEndList()
    
    return lista
    
#####################################################################

def drawList(lista,pos = [0.0,0.0,0.0],o = 0.0,rot = None,sz = None,rgb = None):
    glPushMatrix()
    
    glTranslatef(pos[0],pos[1],pos[2])
    
    if (rot != None):
        glRotatef(o,rot[0],rot[1],rot[2])
        
    if (sz != None):
        glScalef(sz[0],sz[1],sz[2])
    
    if (rgb != None):
        glColor4fv(rgb)
    
    glCallList(lista)
    
    glPopMatrix()
    
#####################################################################

def plusList(a,b):
    d = len(a)
    
    c = []
    for i in range(0,d):
        c.append(a[i]+b[i])
    
    return c

def scaleList(s,a):
    d = len(a)
    
    c = []
    for i in range(0,d):
        c.append(a[i]*s)
    
    return c

def meanList(lists):
    n = len(lists)
    d = len(lists[0])
    
    c = []
    for i in range(0,d):
        c.append(0.0)
    
    for l in lists:
        c = plusList(c,l)
        
    return scaleList( 1/float(n) , c)

#####################################################################  
        
def generarTex(filename,repeat = False, alpha = False):
    
    import Image
    import numpy
    
    print "filename = ",filename
    
    img = Image.open(filename)
    img_data = numpy.array(list(img.getdata()), numpy.int8) #Se supone que hace mas rapido la lectura y escritura...

    texture = glGenTextures(1)
    glPixelStorei(GL_UNPACK_ALIGNMENT,1)
    glBindTexture(GL_TEXTURE_2D, texture)
    
    if (repeat):
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
    else:
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
        
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
    
    if alpha: #Si posee transparencias
        glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, img.size[0], img.size[1], 0, GL_RGBA, GL_UNSIGNED_BYTE, img_data)
    else:    #No posee transparencias
        glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, img.size[0], img.size[1], 0, GL_RGB, GL_UNSIGNED_BYTE, img_data)

    glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE)

    return texture
    
def loadTexture(filename):
    
    import pygame    
    
    surf = pygame.image.load(filename)
    image = pygame.image.tostring(surf, 'RGBA', 1)
    ix, iy = surf.get_rect().size
    texid = glGenTextures(1)
    glBindTexture(GL_TEXTURE_2D, texid)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, ix, iy, 0, GL_RGBA, GL_UNSIGNED_BYTE, image)
    
    return texid
    
#####################################################################

def stlList(stlfile):
    
    f = open(stlfile,"r")
    
    lista = glGenLists(1)
    glNewList(lista, GL_COMPILE)
    
    glBegin(GL_TRIANGLES)
    
    for l in f.readlines():
        a = l.split()
        
        if (a[0] == 'facet'):
            glNormal3f(float(a[2]),float(a[3]),float(a[4]))
            
        elif (a[0] == 'vertex'):
            glVertex3f(float(a[1]),float(a[2]),float(a[3]))
    
    glEnd()
    
    glEndList()
    
    f.close()
    
    return lista

#####################################################################
 
def objList_objloader(filename, verbose = False):
    
    if (verbose):
        print "loading file = ",filename," ... ",
    
    import objloader
    
    obj = objloader.OBJ(filename)
    
    if (verbose):
        print "ok"
    
    return obj.gl_list
    
#####################################################################
 
class MTL:
    def __init__(self, name):
        self.name = name
        self.Ka = [0.0,0.0,0.0]
        self.Kd = [0.0,0.0,0.0]
        self.Ks = [0.0,0.0,0.0]
        self.Ns = 0.0
        self.d = 0.0
        self.illum = 0
        self.map_Ka = ""
        self.map_Kd = ""
        self.map_Ks = ""
        self.map_Ns = ""
        self.map_d = ""
        self.map_bump = ""
        
        self.tx = None
        
def mtlLookFor(mtls,mtlname):
    for mtl in mtls:
        if mtl.name == mtlname:
            return mtl
            
    return None
    
def loadMTL(filename,useTextures = False):
    #print filename
    file_ = open(filename,"r")
    
    mtls = []
    i = -1
    
    for l in file_.readlines():
        
        a = l.split()
        
        if (len(a) == 0):
            continue
        
        if (a[0] == '#'):
            continue
        
        elif (a[0] == "newmtl"):
            s = ""
            if (len(a) >= 1):
                s = l[7:len(l)]
                
            mtl = MTL(s);
            mtls.append(mtl)
            i += 1
                
        elif (a[0] == "Ka"):
            mtls[i].Ka = map(float,a[1:4])
            
        elif (a[0] == "Kd"):
            mtls[i].Kd = map(float,a[1:4])
            
        elif (a[0] == "Ks"):
            mtls[i].Ks = map(float,a[1:4])
            
        elif (a[0] == "Ns"):
            mtls[i].Ns = float(a[1])
            
        elif (a[0] == "d" or a[0] == "Tr"):
            mtls[i].d = float(a[1])
            
        elif (a[0] == "illum"):
            mtls[i].illum = int(a[1])
            
        elif (a[0] == "map_Ka"):
            mtls[i].map_Ka = a[1]
            
        elif (a[0] == "map_Kd"):
            mtls[i].map_Kd = a[1]
            
            if (useTextures):
                if (not mtls[i].map_Kd == ""):
                    mtls[i].tx = loadTexture(mtls[i].map_Kd)
            
        elif (a[0] == "map_Ks"):
            mtls[i].map_Ks = a[1]
            
        elif (a[0] == "map_Ns"):
            mtls[i].map_Ns = a[1]
            
        elif (a[0] == "map_d"):
            mtls[i].map_d = a[1]
            
        elif (a[0] == "map_bump"):
            mtls[i].map_bump = a[1]
        
    file_.close()
    
    return mtls
    
def objList(filename, useMTL = False, useTextures = False, verbose = False):
    # filename    : nombre del archivo .obj
    # useMTL      : booleano que dice si utiliza o no archivo de materiales.
    # useTextures : booleano que dice si utiliza o no las texturas referenciadas.
    
    if (verbose):
        print "loading file = ",filename," ... ",
    
    if (not useMTL):
        useTextures = False
    
    file_ = open(filename,"r")
    
    vs = []
    
    ts = []
    
    ns = []
    
    fs = []
    
    # almacenar líneas en estructura temporal
    for l in file_.readlines():        
        #print "l = ",l
        a = l.split()
        #print "a = ",a
        
        if (len(a) == 0):
            continue
        
        if (a[0] == '#'):
            continue
        
        elif (a[0] == 'v'):
            vs.append(map(float,a[1:len(a)]))
            # len = 3 o 4 si son cartesianas u homogeneas.
                
        elif (a[0] == 'vn'):
            ns.append(map(float, a[1:4]))
            
        elif (useMTL and a[0] == 'vt'):
            ts.append(map(float, a[1:3]))
            
        elif (a[0] == 'f'):
            
            f = []
            
            # permite caras de 2,3,4, etc vértices ...
            for i in range(1,len(a)):
                aa = a[i].split("/")
                n = len(aa)
                
                if (n == 1):
                    f.append([int(aa[0])])
                    
                elif (n == 2):
                    f.append([int(aa[0]),int(aa[1])])
                    
                elif (n == 3):
                    if (aa[1] == ''):
                        f.append([int(aa[0]),-1,int(aa[2])])
                    else:
                        f.append([int(aa[0]),int(aa[1]),int(aa[2])])
                
            fs.append(f)
            
        elif (useMTL and a[0] == "mtllib"):
            s = l[7:len(l)]
            s = s.strip()
            mtls = loadMTL(s,useTextures)
            
        elif (useMTL and a[0] == "usemtl"):
            s = l[7:len(l)]
            mtl = mtlLookFor(mtls,s)
            fs.append([[-1,mtl]])
            
    file_.close()
            
    # armar caras y generar lista opengl
    
    lista = glGenLists(1)
    glNewList(lista, GL_COMPILE)
    
    p = 0
    
    mtl = None
    
    for f in fs:
        #print "face = ",f
        
        t = len(f)
        n = len(f[0])   # especificacion de cara
        
        if (useMTL and t == 1 and n == 2):
            if (f[0][0] == -1):    # especificación de material
            
                if (useTextures):                
                    if (mtl != None):
                        # hay un material anterior
                        if (mtl.map_Kd != ""):
                            # hay textura en el material anterior
                            glDisable(GL_TEXTURE_2D)
                            
                mtl = f[0][1]      # mtl a utilizar desde ahora...
                
                alpha = 1.0
                if (mtl.illum > 3):
                    alpha = mtl.d
                
                glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, mtl.Ka + [alpha])
                glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, mtl.Kd + [alpha])
                glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR,mtl.Ks + [alpha])
                
                shininess = mtl.Ns*128.0/1000.0
                
                glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, [shininess])
                
                glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, [0.0,0.0,0.0,1.0])
                
                if (useTextures):
                    if (not mtl.map_Kd == ""):
                        glEnable(GL_TEXTURE_2D)
                        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE)
                        glBindTexture(GL_TEXTURE_2D, mtl.tx)
                        
                # implementación incompleta
                # falta implementar varias características de los obj/mtl.
                # referencias desde ...
                # http://en.wikipedia.org/wiki/Wavefront_.obj_file
        
        elif (t == 2):    # LINES
            glBegin(GL_LINES)
            
            if (n == 1 or (n == 2 and not useTextures)):    # solo vértices
                glVertex3fv(vs[f[0][0]-1])
                glVertex3fv(vs[f[1][0]-1])
                
            elif (n == 2):  # vértices/texturas
                glTexCoord2fv(ts[f[0][1]-1])
                glVertex3fv(vs[f[0][0]-1])
                
                glTexCoord2fv(ts[f[1][1]-1])
                glVertex3fv(vs[f[1][0]-1])
                
            elif (n == 3):
                
                if (f[1][0] == -1 or not useTextures): # vértices//normales
                    glNormal3fv(ns[f[0][2]-1])
                    glVertex3fv(vs[f[0][0]-1])
                    
                    glNormal3fv(ns[f[1][2]-1])
                    glVertex3fv(vs[f[1][0]-1])
                    
                else:               # vértices/texturas/normales
                    glTexCoord2fv(ts[f[0][1]-1])
                    glNormal3fv(ns[f[0][2]-1])
                    glVertex3fv(vs[f[0][0]-1])
                    
                    glTexCoord2fv(ts[f[1][1]-1])
                    glNormal3fv(ns[f[1][2]-1])
                    glVertex3fv(vs[f[1][0]-1])
            
            glEnd()
        
        elif (t == 3):    # TRIANGLES
        
            glBegin(GL_TRIANGLES)
            
            if (n == 1 or (n == 2 and not useTextures)):    # solo vértices
                glVertex3fv(vs[f[0][0]-1])
                glVertex3fv(vs[f[1][0]-1])
                glVertex3fv(vs[f[2][0]-1])
                
            elif (n == 2):  # vértices/texturas
                glTexCoord2fv(ts[f[0][1]-1])
                glVertex3fv(vs[f[0][0]-1])
                
                glTexCoord2fv(ts[f[1][1]-1])
                glVertex3fv(vs[f[1][0]-1])
                
                glTexCoord2fv(ts[f[2][1]-1])
                glVertex3fv(vs[f[2][0]-1])
                
            elif (n == 3):
                
                if (f[0][1] == -1 or not useTextures): # vértices//normales
                    glNormal3fv(ns[f[0][2]-1])
                    glVertex3fv(vs[f[0][0]-1])
                    
                    glNormal3fv(ns[f[1][2]-1])
                    glVertex3fv(vs[f[1][0]-1])
                    
                    glNormal3fv(ns[f[2][2]-1])
                    glVertex3fv(vs[f[2][0]-1])
                    
                else:               # vértices/texturas/normales
                    glTexCoord2fv(ts[f[0][1]-1])
                    glNormal3fv(ns[f[0][2]-1])
                    glVertex3fv(vs[f[0][0]-1])
                    
                    glTexCoord2fv(ts[f[1][1]-1])
                    glNormal3fv(ns[f[1][2]-1])
                    glVertex3fv(vs[f[1][0]-1])
                    
                    glTexCoord2fv(ts[f[2][1]-1])
                    glNormal3fv(ns[f[2][2]-1])
                    glVertex3fv(vs[f[2][0]-1])
                    
            glEnd()
                    
        elif (t == 4):       # QUADS
        
            glBegin(GL_QUADS)
            
            if (n == 1 or (n == 2 and not useTextures)):    # solo vértices
                glVertex3fv(vs[f[0][0]-1])
                glVertex3fv(vs[f[1][0]-1])
                glVertex3fv(vs[f[2][0]-1])
                glVertex3fv(vs[f[3][0]-1])
                
            elif (n == 2):  # vértices/texturas
                glTexCoord2fv(ts[f[0][1]-1])
                glVertex3fv(vs[f[0][0]-1])
                
                glTexCoord2fv(ts[f[1][1]-1])
                glVertex3fv(vs[f[1][0]-1])
                
                glTexCoord2fv(ts[f[2][1]-1])
                glVertex3fv(vs[f[2][0]-1])
                
                glTexCoord2fv(ts[f[3][1]-1])
                glVertex3fv(vs[f[3][0]-1])
                
            elif (n == 3):
                
                if (f[1][0] == -1 or not useTextures): # vértices//normales
                    glNormal3fv(ns[f[0][2]-1])
                    glVertex3fv(vs[f[0][0]-1])
                    
                    glNormal3fv(ns[f[1][2]-1])
                    glVertex3fv(vs[f[1][0]-1])
                    
                    glNormal3fv(ns[f[2][2]-1])
                    glVertex3fv(vs[f[2][0]-1])
                    
                    glNormal3fv(ns[f[3][2]-1])
                    glVertex3fv(vs[f[3][0]-1])
                    
                else:               # vértices/texturas/normales
                    glTexCoord2fv(ts[f[0][1]-1])
                    glNormal3fv(ns[f[0][2]-1])
                    glVertex3fv(vs[f[0][0]-1])
                    
                    glTexCoord2fv(ts[f[1][1]-1])
                    glNormal3fv(ns[f[1][2]-1])
                    glVertex3fv(vs[f[1][0]-1])
                    
                    glTexCoord2fv(ts[f[2][1]-1])
                    glNormal3fv(ns[f[2][2]-1])
                    glVertex3fv(vs[f[2][0]-1])
                    
                    glTexCoord2fv(ts[f[3][1]-1])
                    glNormal3fv(ns[f[3][2]-1])
                    glVertex3fv(vs[f[3][0]-1])
                    
            glEnd()
        else:
            print f," vertex faces have been not implemented"
            p += 1
    
    if (p != 0):
        print "WARNING: ",p," faces have not been processed correctly"
        
    if (useTextures):
        glDisable(GL_TEXTURE_2D)
    
    glEndList()
    
    if (verbose):
        print "ok"
    
    return lista